#############Imports###################
import xbmc,xbmcaddon,xbmcgui,xbmcplugin
import os,sys,urllib,re,base64,datetime,time
from datetime import date
from resources.lib.modules import tools
from pathlib import Path
#0.0.7#################################

import requests
import xbmcvfs
import urllib.parse
import sqlite3

headers = {
	'User-Agent': 'okhttp/3.10.0'
}

#############Defined Strings#############
addon_name	= xbmcaddon.Addon().getAddonInfo('name')
addon_id	= xbmcaddon.Addon().getAddonInfo('id')

fanart			= xbmcvfs.translatePath(os.path.join(xbmcaddon.Addon().getAddonInfo('path'), "resources", "media", "fanart.jpg"))
icon_dir		= xbmcvfs.translatePath(os.path.join(xbmcaddon.Addon().getAddonInfo('path'), "resources", "media", "icons", ""))
accounticon		= icon_dir + 'account.png'
livetvicon		= icon_dir + 'livetv.png'
vodicon			= icon_dir + 'vod.png'
seriesicon		= icon_dir + 'tv.png'
currenticon		= icon_dir + 'current.png'
allowedicon		= icon_dir + 'allowed.png'
usericon		= icon_dir + 'user.png'
passicon		= icon_dir + 'pass.png'
dateicon		= icon_dir + 'date.png'
statusicon		= icon_dir + 'status.png'
searchicon		= icon_dir + 'search.png'
settingsicon	= icon_dir + 'settings.png'
dataicon		= icon_dir + 'meta.png'
xxxicon			= icon_dir + 'xxx.png'
cacheicon		= icon_dir + 'clear.png'
advancedicon	= icon_dir + 'eas.png'
speedicon		= icon_dir + 'speed.png'
logouticon		= icon_dir + 'logout.png'
catchupicon		= icon_dir + 'catchup.png'

advanced_settings			= xbmcvfs.translatePath(os.path.join(xbmcaddon.Addon().getAddonInfo('path'), "resources", "data", "advanced_settings"))
advanced_settings_target	= xbmcvfs.translatePath(os.path.join('special://home/userdata','advancedsettings.xml'))

hosts_icon 		= xbmcvfs.translatePath(os.path.join(xbmcaddon.Addon().getAddonInfo('path'), "resources", "media", "hosts", "icons", ""))
hosts_fanart 	= xbmcvfs.translatePath(os.path.join(xbmcaddon.Addon().getAddonInfo('path'), "resources", "media", "hosts", "fanart", ""))
hosts_path		= xbmcvfs.translatePath(os.path.join(xbmcaddon.Addon().getAddonInfo('path'), "resources", "data", "hosts"))
users_path		= xbmcvfs.translatePath(os.path.join('special://home/userdata/addon_data/' + addon_id +'/','users.db'))

profile_dir = xbmcvfs.translatePath(xbmcaddon.Addon().getAddonInfo('profile'))


####################################DATABASE

def hosts_read(name):
	con = sqlite3.connect(hosts_path)
	cur = con.cursor()
	try:
		for row in cur.execute("SELECT name, dns, port FROM hosts WHERE name=:name", {"name": name}):
			host = base64.b64decode(row[1]).decode('utf-8')
			port = base64.b64decode(row[2]).decode('utf-8')
		con.close()
		return host, port
	except:
		return '',''


def users_read(name):
	con = sqlite3.connect(users_path)
	cur = con.cursor()
	try:
		for row in cur.execute("SELECT username, password FROM users WHERE name=:name", {"name": name}):
			username = str(row[0])
			password = str(row[1])
		con.close()
		return username, password
	except:
		return '',''


def users_delete():
	con = sqlite3.connect(users_path)
	cur = con.cursor()
	try:
		cur.execute("DELETE FROM users WHERE name = ?",(xtra,))
	except:pass
	con.commit()
	con.close()
	return


def users_insert(name,username,password):
	con = sqlite3.connect(users_path)
	cur = con.cursor()
	try:
		cur.execute("DELETE FROM users WHERE name = ?",(name,))
	except:pass
	cur.execute("INSERT INTO users VALUES (?, ?, ?)", (name,username,password))
	con.commit()
	con.close()


###################################

def hosts():
	try:
		path = xbmcvfs.translatePath(os.path.join('special://home/userdata/addon_data/' + addon_id))
		os.makedirs( path, exist_ok=True )
		con = sqlite3.connect(users_path)
		cur = con.cursor()
		cur.execute('''CREATE TABLE users
				(name text, username text, password text)''')
		con.close()
	except:pass
	con = sqlite3.connect(hosts_path)
	cur = con.cursor()
	for row in cur.execute('SELECT Yan, Tan, Tethera FROM hosts ORDER BY Yan'):
		expiry = ''
		xtra = '%s' % (base64.b64decode(row[0]).decode('utf-8'))
		name = '%s' % (base64.b64decode(row[0]).decode('utf-8'))
		my_file = Path(hosts_icon + base64.b64decode(row[0]).decode('utf-8').lower() + '.png')
		if my_file.is_file():
			icon = hosts_icon + base64.b64decode(row[0]).decode('utf-8').lower() + '.png'
		else:
			icon = xbmcvfs.translatePath(os.path.join(xbmcaddon.Addon().getAddonInfo('path'), "resources", "media", "icon.png"))
		my_file = Path(hosts_fanart + base64.b64decode(row[0]).decode('utf-8').lower() + '.png')
		if my_file.is_file():
			fanart = hosts_fanart + base64.b64decode(row[0]).decode('utf-8').lower() + '.png'
		else:
			fanart = xbmcvfs.translatePath(os.path.join(xbmcaddon.Addon().getAddonInfo('path'), "resources", "media", "fanart.jpg"))
		dns = '%s:%s' % (base64.b64decode(row[1]).decode('utf-8'),base64.b64decode(row[2]).decode('utf-8'))
		username = users_read(base64.b64decode(row[0]).decode('utf-8'))[0]
		password = users_read(base64.b64decode(row[0]).decode('utf-8'))[1]
		if username == '' and password == '':
			msg = '[B][COLOR yellow]%s[/COLOR][/B]' % (xtra)
		else:
			name = '%s [COLOR lime]\U000000AE[/COLOR]' % (base64.b64decode(row[0]).decode('utf-8'))# R
			expiry = account_info('expiry',dns,username,password)
			if xbmcaddon.Addon().getSetting('showuserpass')=='false':
				msg = '[B][COLOR yellow]%s[/COLOR][/B]\n[B][COLOR orange]Expiry Date : %s[/COLOR][/B]' % (xtra,expiry)
			else:
				msg = '[B][COLOR yellow]%s[/COLOR][/B]\nUsername: [B][COLOR lime]%s[/COLOR][/B]\nPassword: [B][COLOR lime]%s[/COLOR][/B]\n[B][COLOR orange]Expiry Date : %s[/COLOR][/B]' % (xtra,username,password,expiry)
		addDir(name,dns,101,icon,fanart,msg,xtra,dns,username,password)
	con.close()
	xbmcplugin.addSortMethod(handle=int(sys.argv[1]), sortMethod=xbmcplugin.SORT_METHOD_TITLE)


def check(name):
	user = users_read(name)[0]
	passw = users_read(name)[1]
	url = '%s/player_api.php?username=%s&password=%s'%(dns,user,passw)
	xbmc.log("check: %s"%(url),level=3)
	try:
		data = requests.get(url, headers=headers).json()
		if 'status' in data['user_info']:
			home(dns,user,passw)
	except:
		msg = "[B][COLOR red]Please Enter Login Details[/COLOR][/B]"
		xbmcgui.Dialog().ok('Attention', msg)
		user = xbmcgui.Dialog().input("Please Enter Username")
		passw = xbmcgui.Dialog().input("Please Enter Password")
		url = '%s/player_api.php?username=%s&password=%s'%(dns,user,passw)
		try:
			data = requests.get(url, headers=headers).json()
			if 'status' in data['user_info']:
				msg = "Login Successful\nWelcome to [B][COLOR orange]%s[/COLOR][/B]\n[B][COLOR cyan]%s[/COLOR][/B]"%(name,user)
				xbmcgui.Dialog().ok('Login', msg)
				username = user
				password = passw
				users_insert(name,username,password)
				if not os.path.exists(advanced_settings_target)==True:
					addonsettings('ADS2','')
				else:
					pass
				xbmc.executebuiltin('Container.Update(path,replace)')
				xbmc.executebuiltin('RunAddon(%s)' % (addon_id))


		except:
			msg = "[B][COLOR red]Login Details Incorrect[/COLOR][/B]\n\nTry Again or Exit?"
			dialog = xbmcgui.Dialog()
			ret = dialog.yesno('Attention', msg, 'Try Again', 'Exit')
			if ret == True:
#				return
				xbmc.executebuiltin('Container.Update(path,replace)')
				xbmc.executebuiltin('RunAddon(%s)' % (addon_id))

			else:
				check(name)


def home(dns,username,password):
	my_file = Path(hosts_fanart + xtra.lower() + '.png')
	if my_file.is_file():
		fanart = hosts_fanart + xtra.lower() + '.png'
	else:
		fanart = xbmcvfs.translatePath(os.path.join(xbmcaddon.Addon().getAddonInfo('path'), "resources", "media", "fanart.jpg"))
	url1 = '%s/player_api.php?username=%s&password=%s&action=get_live_streams'%(dns,username,password)
	catchup = ''
	live = ''
	try:
		data = requests.get(url1, headers=headers).json()
		for a in data:
			tv_archive = a['tv_archive']
			if tv_archive == 1:
				catchup = True
			stream_type = a['stream_type']
			if stream_type == 'live':
				live = True
	except:pass
	if live == True:
		description = '[B][COLOR yellow]%s[/COLOR][/B]\n%s' % (xtra,'Live Channels')
		addDir('[B][COLOR white]Live[/COLOR][/B]',dns,22,livetvicon,fanart,description,xtra,dns,username,password)
		live = ''
	url = '%s/player_api.php?username=%s&password=%s&action=get_vod_streams'%(dns,username,password)
	vod = ''
	try:
		data = requests.get(url, headers=headers).json()
		for a in data:
			stream_type = a['stream_type']
			if stream_type == 'movie':
				vod = True
	except:pass
	if vod == True:
		description = '[B][COLOR yellow]%s[/COLOR][/B]\n%s' % (xtra,'Movies')
		addDir('[B][COLOR white]Movies[/COLOR][/B]','url',42,vodicon,fanart,description,xtra,dns,username,password)
		vod = ''
	url = '%s/player_api.php?username=%s&password=%s&action=get_series'%(dns,username,password)
	series = ''
	try:
		data = requests.get(url, headers=headers).json()
		for a in data:
				if a['series_id']:
					series = True
	except:pass
	if series == True:
		description = '[B][COLOR yellow]%s[/COLOR][/B]\n%s' % (xtra,'TV Shows')
		addDir('[B][COLOR white]TV Shows[/COLOR][/B]','url',52,seriesicon,fanart,description,xtra,dns,username,password)
		series = ''
	if catchup == True:
		description = '[B][COLOR yellow]%s[/COLOR][/B]\n%s' % (xtra,'Catch Up TV')
		addDir('[B][COLOR white]Catch Up TV[/COLOR][/B]','url',8,catchupicon,fanart,description,xtra,dns,username,password)
		catchup = ''
	description = '[B][COLOR yellow]%s[/COLOR][/B]\n%s' % (xtra,'Tools')
	addDir('[B][COLOR white]Tools[/COLOR][/B]','url',7,settingsicon,fanart,description,xtra,dns,username,password)
	expiry = account_info('expiry',dns,username,password)
	expiry = '[B][COLOR orange]Expiry Date : %s[/COLOR][/B]' % (str(expiry))
	description = '[B][COLOR yellow]%s[/COLOR][/B]\n%s' % (xtra,'Expiry Date')
	url1 = '%s/player_api.php?username=%s&password=%s'%(dns,username,password)
	addDir(expiry,url1,1,accounticon,fanart,description,xtra,dns,username,password)


def get_live_streams_all():#[21]
	url = '%s/player_api.php?username=%s&password=%s&action=get_live_streams'%(dns,username,password)
	data = requests.get(url, headers=headers).json()
	for a in data:
		stream_type = a['stream_type']
		stream_id = a['stream_id']
		name = a['name']
		thumb = a['stream_icon'] or ''
		fanart = hosts_fanart + xtra.lower() + '.png'
		short_epg = ''
		url1 = '%s/%s/%s/%s/%s.ts'%(dns,stream_type,username,password,stream_id)
		if xbmcaddon.Addon().getSetting('hidexxx')=='true':
			addDir(name,url1,999,thumb,fanart,str(short_epg),xtra,dns,username,password)
		else:
			if not 'XXX' in name:
				if not 'Adult' in name:
					addDir(name,url1,999,thumb,fanart,str(short_epg),xtra,dns,username,password)
	xbmcplugin.addSortMethod(handle=int(sys.argv[1]), sortMethod=xbmcplugin.SORT_METHOD_TITLE)


def get_live_categories():#[22]
	live_url = '%s/player_api.php?username=%s&password=%s&action=get_live_categories'%(dns,username,password)
	fanart = hosts_fanart + xtra.lower() + '.png'
	data = requests.get(live_url).json()
	description = '[B][COLOR yellow]%s[/COLOR][/B]\n%s' % (xtra,'Live Categories')
	addDir('[B][COLOR orange]Search Live Channels[/COLOR][/B]',url,29,livetvicon,fanart,description,xtra,dns,username,password)
	addDir('[B][COLOR grey]All Live Channels[/COLOR][/B]','LIVE',21,livetvicon,fanart,description,xtra,dns,username,password)
	for a in data:
		cat_id = a['category_id']
		name ='[B][COLOR white]%s[/COLOR][/B]' % (a['category_name'])
		parent_id = a['parent_id']
		url1 = '%s/player_api.php?username=%s&password=%s&action=get_live_streams&category_id=%s'%(dns,username,password,cat_id)
		msg = '[B][COLOR yellow]%s[/COLOR][/B]\n%s' % (xtra,'Live Categories')
		if xbmcaddon.Addon().getSetting('hidexxx')=='true':
			addDir(name,url1,23,livetvicon,fanart,msg,xtra,dns,username,password)
		else:
			if not 'XXX' in name:
				if not 'Adult' in name:
					addDir(name,url1,23,livetvicon,fanart,msg,xtra,dns,username,password)


def get_live_streams_category():#[23]
	data = requests.get(url, headers=headers).json()
	for a in data:
		num = a['num']
		name = a['name']
		stream_type = a['stream_type']
		thumb = a['stream_icon']
		stream_id = a['stream_id']
		short_epg = name
		url1 = '%s/%s/%s/%s/%s.ts'%(dns,stream_type,username,password,stream_id)
		fanart = hosts_fanart + xtra.lower() + '.png'
		if xbmcaddon.Addon().getSetting('hidexxx')=='true':
			addDir(name,url1,999,thumb,fanart,'test','',dns,username,password)
		else:
			if not 'XXX' in name:
				if not 'Adult' in name:
					addDir(name,url1,999,thumb,fanart,'test','',dns,username,password)

 
def search_live():#[29]
	text = xbmcgui.Dialog().input("Search for a Live Channel")
	if not text:
		xbmcgui.Dialog().notification('Search Live','[COLOR orange][B]Search is Empty[/B][/COLOR]', xbmcgui.NOTIFICATION_ERROR, 4000)
		return
	url1 = '%s/player_api.php?username=%s&password=%s&action=get_live_streams'%(dns,username,password)
	data = requests.get(url1, headers=headers).json()
	for a in data:
		stream_type = a['stream_type']
		stream_id = a['stream_id']
		name = a['name']
		thumb = a['stream_icon'] or ''
		fanart = hosts_fanart + xtra.lower() + '.png'
		short_epg = ''
		if text.lower() in name.lower():
			url1 = '%s/%s/%s/%s/%s.ts'%(dns,stream_type,username,password,stream_id)
			addDir(name,url1,999,thumb,fanart,str(short_epg),xtra,dns,username,password)
	xbmcplugin.addSortMethod(handle=int(sys.argv[1]), sortMethod=xbmcplugin.SORT_METHOD_TITLE)


def get_short_epg(stream_id,limit):
	url_epg = '%s/player_api.php?username=%s&password=%s&action=get_short_epg&stream_id=%s&limit=%s'%(dns,username,password,stream_id,limit)
	data = requests.get(url_epg, headers=headers).json()
	now_next=[]
	for x in range(0, len(data['epg_listings'])):
		title = '[COLOR cyan]%s[/COLOR]' % (base64.b64decode(data['epg_listings'][x]['title']).decode('utf-8'))
		description = base64.b64decode(data['epg_listings'][x]['description']).decode('utf-8')
		startHM = data['epg_listings'][x]['start_timestamp']
		startHM = '[B][COLOR yellow]%s[/COLOR][/B]' % (datetime.datetime.fromtimestamp(int(startHM)).strftime('%H:%M'))
		now_next.append(startHM)
		now_next.append(title)
		now_next.append('\n')
		now_next.append(description)
		now_next.append('\n')
	str1 = " "
	return (str1.join(now_next))


def get_vod_streams_all():#[41]
	url = '%s/player_api.php?username=%s&password=%s&action=get_vod_streams'%(dns,username,password)
	data = requests.get(url, headers=headers).json()
	for a in data:
		if a['name']:
			name = a['name']
		else:
			name = 'No Name'
		stream_type = a['stream_type']
		stream_id = a['stream_id']
		container_extension = a['container_extension']
		if a['stream_icon']:
			iconimage = a['stream_icon']
		else:
			iconimage = ''
		rating = a['rating']
		rating_5based = a['rating_5based']
		description = '\n\n[B][COLOR cyan]Ratings:[/COLOR][/B] %s (%s/5)'%(str(rating),rating_5based)
		fanart = hosts_fanart + xtra.lower() + '.png'
		if xbmcaddon.Addon().getSetting('meta') == 'true':
			url1 = str(stream_id)
			if xbmcaddon.Addon().getSetting('hidexxx')=='true':
				addDir(name,url1,44,iconimage,fanart,description,xtra,dns,username,password)
			else:
				if not 'XXX' in name:
					if not 'Adult' in name:
						addDir(name,url1,44,iconimage,fanart,description,xtra,dns,username,password)
		else:
			url1 = '%s/%s/%s/%s/%s.%s'%(dns,stream_type,username,password,stream_id,container_extension)
			if xbmcaddon.Addon().getSetting('hidexxx')=='true':
				addDir(name,url1,99,iconimage,fanart,description,xtra,dns,username,password)
			else:
				if not 'XXX' in name:
					if not 'Adult' in name:
						addDir(name,url1,99,iconimage,fanart,description,xtra,dns,username,password)
	xbmcplugin.addSortMethod(handle=int(sys.argv[1]), sortMethod=xbmcplugin.SORT_METHOD_TITLE)


def get_vod_categories():#[42]
	url = '%s/player_api.php?username=%s&password=%s&action=get_vod_categories'%(dns,username,password)
	data = requests.get(url, headers=headers).json()
	fanart = hosts_fanart + xtra.lower() + '.png'
	description = '[B][COLOR yellow]%s[/COLOR][/B]\n%s' % (xtra,'Movie Categories')
	addDir('[B][COLOR orange]Search Movies[/COLOR][/B]','VOD',49,vodicon,fanart,description,xtra,dns,username,password)
	addDir('[B][COLOR grey]All Movies[/COLOR][/B]','VOD',41,vodicon,fanart,description,xtra,dns,username,password)
	for a in data:
		name = '[B][COLOR white]%s[/COLOR][/B]' % (a['category_name'])
		cat_id = a['category_id']
		url1 = '%s/player_api.php?username=%s&password=%s&action=get_vod_streams&category_id=%s'%(dns,username,password,cat_id)
		if xbmcaddon.Addon().getSetting('hidexxx')=='true':
			addDir(name,url1,43,vodicon,fanart,description,xtra,dns,username,password)
		else:
			if not 'XXX' in name:
				if not 'Adult' in name:
					addDir(name,url1,43,vodicon,fanart,description,xtra,dns,username,password)


def get_vod_streams_by_catagory(url):#[43]
	data = requests.get(url, headers=headers).json()
	for a in data:
		if a['name']:
			name = a['name']
		else:
			name = 'No Name!'
		stream_type = a['stream_type']
		stream_id = a['stream_id']
		container_extension = a['container_extension']
		if a['stream_icon']:
			iconimage = a['stream_icon']
		else:
			iconimage = ''
		rating = a['rating']
		rating_5based = a['rating_5based']
		description = '\n\n[B][COLOR cyan]Ratings:[/COLOR][/B] %s (%s/5)\n\n[B][COLOR yellow]%s[/COLOR][/B]' % (str(rating),rating_5based,xtra)
		fanart = hosts_fanart + xtra.lower() + '.png'
		if xbmcaddon.Addon().getSetting('meta') == 'true':
			url1 = str(stream_id)
			if xbmcaddon.Addon().getSetting('hidexxx')=='true':
				addDir(name,url1,44,iconimage,fanart,description,xtra,dns,username,password)
			else:
				if not 'XXX' in name:
					if not 'Adult' in name:
						addDir(name,url1,44,iconimage,fanart,description,xtra,dns,username,password)
		else:
			url1 = '%s/%s/%s/%s/%s.%s'%(dns,stream_type,username,password,stream_id,container_extension)
			if xbmcaddon.Addon().getSetting('hidexxx')=='true':
				addDir(name,url1,99,iconimage,fanart,description,xtra,dns,username,password)
			else:
				if not 'XXX' in name:
					if not 'Adult' in name:
						addDir(name,url1,99,iconimage,fanart,description,xtra,dns,username,password)
	xbmcplugin.addSortMethod(handle=int(sys.argv[1]), sortMethod=xbmcplugin.SORT_METHOD_TITLE)


def get_vod_info(stream_id):#[44]
	url_info = '%s/player_api.php?username=%s&password=%s&action=get_vod_info&vod_id=%s'%(dns,username,password,stream_id)
	data = requests.get(url_info, headers=headers).json()
	stream_type = 'movie'
	stream_id = data['movie_data']['stream_id']
	container_extension = data['movie_data']['container_extension']
	url1 = '%s/%s/%s/%s/%s.%s'%(dns,stream_type,username,password,stream_id,container_extension)
	if not data['info'].get('name'):
		name = data['movie_data']['name']
	else:
		name = data['info']['name']
	if not data['info'].get('movie_image'):
		thumb = ''
	else:
		thumb = data['info']['movie_image']
	if not data['info'].get('plot'):
		plot = ''
	else:
		plot = data['info']['plot']
	if not data['info'].get('director'):
		director = ''
	else:
		director = data['info']['director']
	if not data['info'].get('cast'):
		cast = ''
	else:
		cast = data['info']['cast']
	if not data['info'].get('rating'):
		ratin = ''
	else:
		ratin = data['info']['rating']
	if not data['info'].get('releasedate'):
		year = ''
	else:
		year = data['info']['releasedate']
	if not data['info'].get('genre'):
		genre = ''
	else:
		genre = data['info']['genre']
	if not data['info'].get('duration_secs'):
		runt = ''
	else:
		runt = data['info']['duration_secs']
	if not data['info'].get('tmdb_id'):
		tmdb_id = ''
	else:
		tmdb_id = data['info']['tmdb_id']
	if data['info'].get('backdrop'):
		fanart = data['info']['backdrop'].split('\r\n')[0]
	elif data['info'].get('backdrop_path'):
		fanart = data['info']['backdrop_path'][0]
	else:
		fanart = hosts_fanart + xtra.lower() + '.png'
	addDirMeta(str(name),url1,99,thumb,fanart,plot,str(year).replace("['","").replace("']",""),str(director).split(','),str(cast).split(','),ratin,runt,genre,xtra,dns,username,password)


def search_vod():#[49]
	text = xbmcgui.Dialog().input("Search for a Movie")
	if not text:
		xbmcgui.Dialog().notification('Search Movies','[COLOR orange][B]Search is Empty[/B][/COLOR]', xbmcgui.NOTIFICATION_ERROR, 4000)
		return
	url = '%s/player_api.php?username=%s&password=%s&action=get_vod_streams'%(dns,username,password)
	data = requests.get(url, headers=headers).json()
	for a in data:
		name = a['name'] or ''
		stream_type = a["stream_type"] or ''
		stream_id = a["stream_id"] or ''
		container_extension = a["container_extension"] or ''
		iconimage = a["stream_icon"] or ''
		description = 'Search Movies'
		fanart = hosts_fanart + xtra.lower() + '.png'
		if text.lower() in name.lower():
			if xbmcaddon.Addon().getSetting('meta') == 'true':
				url1 = str(stream_id)
				addDir(name,url1,44,iconimage,fanart,description,xtra,dns,username,password)
			else:
				url1 = '%s/%s/%s/%s/%s.%s'%(dns,stream_type,username,password,stream_id,container_extension)
				addDir(name,url1,99,iconimage,fanart,description,xtra,dns,username,password)
	xbmcplugin.addSortMethod(handle=int(sys.argv[1]), sortMethod=xbmcplugin.SORT_METHOD_TITLE)


def get_series_streams_all():#[51]
	url = '%s/player_api.php?username=%s&password=%s&action=get_series'%(dns,username,password)
	data = requests.get(url, headers=headers).json()
	for a in data:
		series_id = a['series_id']
		url1 = '%s/player_api.php?username=%s&password=%s&action=get_series_info&series_id=%s'%(dns,username,password,series_id)
		name = a['name']
		thumb = a['cover'] or ''
		plot = a['plot']
		director = a['director']
		cast = a['cast']
		ratin = a['rating']
		year = a['releaseDate']
		runt = a['episode_run_time']
		genre = a['genre']
		if not a['backdrop_path']:
			fanart = hosts_fanart + xtra.lower() + '.png'
		else:
			fanart = a['backdrop_path'][0]
		if xbmcaddon.Addon().getSetting('hidexxx')=='true':
			addDirMeta(str(name),url1,54,thumb,fanart,plot,str(year).replace("['","").replace("']",""),str(director).split(','),str(cast).split(','),ratin,runt,genre,xtra,dns,username,password)
		else:
			if not 'XXX' in name:
				if not 'Adult' in name:
					addDirMeta(str(name),url1,54,thumb,fanart,plot,str(year).replace("['","").replace("']",""),str(director).split(','),str(cast).split(','),ratin,runt,genre,xtra,dns,username,password)
	xbmcplugin.addSortMethod(handle=int(sys.argv[1]), sortMethod=xbmcplugin.SORT_METHOD_TITLE)


def get_series_categories():#[52]
	series_url = '%s/player_api.php?username=%s&password=%s&action=get_series_categories'%(dns,username,password)
	data = requests.get(series_url).json()
	fanart = hosts_fanart + xtra.lower() + '.png'
	description = '[B][COLOR yellow]%s[/COLOR][/B]\n%s' % (xtra,'TV Show Categories')
	addDir('[B][COLOR orange]Search TV Shows[/COLOR][/B]','SERIES',59,seriesicon,fanart,description,xtra,dns,username,password)
	addDir('[B][COLOR grey]All TV Shows[/COLOR][/B]','SERIES',51,seriesicon,fanart,description,xtra,dns,username,password)
	for a in data:
		name = '[B][COLOR white]%s[/COLOR][/B]' % (a['category_name'])
		cat_id = a['category_id']
		url1 = '%s/player_api.php?username=%s&password=%s&action=get_series&category_id=%s'%(dns,username,password,cat_id)
		if xbmcaddon.Addon().getSetting('hidexxx')=='true':
			addDir(name,url1,53,seriesicon,fanart,description,xtra,dns,username,password)
		else:
			if not 'XXX' in name:
				if not 'Adult' in name:
					addDir(name,url1,53,seriesicon,fanart,description,xtra,dns,username,password)


def get_series_by_category(url):#[53]
	data = requests.get(url, headers=headers).json()
	for a in data:
		name = a['name']
		series_id = a['series_id']
		url1 = '%s/player_api.php?username=%s&password=%s&action=get_series_info&series_id=%s'%(dns,username,password,series_id)
		thumb = a['cover']
		if not a['backdrop_path']:
			fanart = ''
		else:
			fanart = a['backdrop_path'][0]
		plot = a['plot']
		year = a['releaseDate']
		director = a['director']
		cast = a['cast']
		rating = a['rating']
		runt = a['episode_run_time']
		genre = a['genre']
		if xbmcaddon.Addon().getSetting('hidexxx')=='true':
			addDirMeta(str(name),url1,54,thumb,fanart,plot,str(year).replace("['","").replace("']",""),str(director).split(','),str(cast).split(','),rating,runt,genre,str(series_id),dns,username,password)
		else:
			if not 'XXX' in name:
				if not 'Adult' in name:
					addDirMeta(str(name),url1,54,thumb,fanart,plot,str(year).replace("['","").replace("']",""),str(director).split(','),str(cast).split(','),rating,runt,genre,str(series_id),dns,username,password)
	xbmcplugin.addSortMethod(handle=int(sys.argv[1]), sortMethod=xbmcplugin.SORT_METHOD_TITLE)


def get_series_info(url):#[54]
	data = requests.get(url, headers=headers).json()
#	try:
	for season in data['episodes']:
		name = '%s : Season %s' %(data['info']['name'],season)
		for episode in data['episodes'][season]:
			if 'plot' in episode['info']:
				if episode['info']['plot']:
					plot = episode['info']['plot']
				else:
					plot = ''
			else:
				plot = ''
			if not data['info']['backdrop_path']:
				fanart = ''
			else:
				fanart = data['info']['backdrop_path'][0]
			director = data['info']['director']
			cast = data['info']['cast']
			if 'rating' in episode['info']:
				rating = episode['info']['rating']
			else:
				rating = ''
			if 'duration_secs' in episode['info']:
				runt = episode['info']['duration_secs']
			else:
				runt = ''
			year = data['info']['releaseDate']
			genre = data['info']['genre']
			thumb = data['info']['cover']
			season_number = season
			xtra1 = season
			url1 = url
		if xbmcaddon.Addon().getSetting('hidexxx')=='true':
			addDirMeta(str(name),url1,55,thumb,fanart,plot,str(year).replace("['","").replace("']",""),str(director).split(','),str(cast).split(','),rating,runt,genre,xtra1,dns,username,password)
		else:
			if not 'XXX' in name:
				if not 'Adult' in name:
					addDirMeta(str(name),url1,55,thumb,fanart,plot,str(year).replace("['","").replace("']",""),str(director).split(','),str(cast).split(','),rating,runt,genre,xtra1,dns,username,password)
#	except:pass


def get_series_episodes(url,season):#[55]
	data = requests.get(url, headers=headers).json()
	try:
		for item in data['episodes'][season]:
			stream_id = item['id']
			container_extension = item['container_extension']
			stream_type = 'series'
			name = item['title']
			url1 = '%s/%s/%s/%s/%s.%s'%(dns,stream_type,username,password,stream_id,container_extension)
			if not data['info']['backdrop_path']:
				fanart = ''
			else:
				fanart = data['info']['backdrop_path'][0]
			if 'movie_image' in item['info']:
				if item['info']['movie_image']:
					thumb = item['info']['movie_image']
				else:
					thumb = fanart
			else:
				thumb = ''
			if 'plot' in item['info']:
				plot = item['info']['plot']
			elif 'overview' in item['info']:
				plot = item['info']['overview']
			else:
				plot = ''
			if 'crew' in item['info']:
				cast = item['info']['crew']
			elif 'cast' in data['info']:
				cast = data['info']['cast']
			else:
				cast = ''
			if 'releasedate' in item['info']:
				year = item['info']['releasedate']
			elif 'release_date' in item['info']:
				year = item['info']['release_date']
			else:
				year = ''
			director = data['info']['director']
			rating = data['info']['rating']
			runt = item['info']['duration_secs']
			genre = data['info']['genre']
			if xbmcaddon.Addon().getSetting('hidexxx')=='true':
				addDirMeta(str(name),url1,99,thumb,fanart,plot,str(year).replace("['","").replace("']",""),str(director).split(','),str(cast).split(','),rating,runt,genre,xtra,dns,username,password)
			else:
				if not 'XXX' in name:
					if not 'Adult' in name:
						addDirMeta(str(name),url1,99,thumb,fanart,plot,str(year).replace("['","").replace("']",""),str(director).split(','),str(cast).split(','),rating,runt,genre,xtra,dns,username,password)
	except:pass


def search_series():#[59]
	text = xbmcgui.Dialog().input("Search for a TV Show")
	if not text:
		xbmcgui.Dialog().notification('Search TV Shows','[COLOR orange][B]Search is Empty[/B][/COLOR]', xbmcgui.NOTIFICATION_ERROR, 4000)
		return
	url = '%s/player_api.php?username=%s&password=%s&action=get_series'%(dns,username,password)
	data = requests.get(url, headers=headers).json()
	for a in data:
		series_id = a['series_id']
		name = a['name']
		thumb = a['cover'] or ''
		plot = a['plot']
		director = a['director']
		cast = a['cast']
		ratin = a['rating']
		year = a['releaseDate']
		runt = a['episode_run_time']
		genre = a['genre']
		if not a['backdrop_path']:
			fanart = fanart
		else:
			fanart = a['backdrop_path'][0]
		if text.lower() in name.lower():
			url1 = '%s/player_api.php?username=%s&password=%s&action=get_series_info&series_id=%s'%(dns,username,password,series_id)
			addDirMeta(str(name),url1,54,thumb,fanart,plot,str(year).replace("['","").replace("']",""),str(director).split(','), str(cast).split(','),ratin,runt,genre,xtra,dns,username,password)
	xbmcplugin.addSortMethod(handle=int(sys.argv[1]), sortMethod=xbmcplugin.SORT_METHOD_TITLE)


########################################CATCHUP

def catchup_channels():#[8]
	url = '%s/player_api.php?username=%s&password=%s&action=get_live_streams'%(dns,username,password)
	data = requests.get(url, headers=headers).json()
	fanart = hosts_fanart + xtra.lower() + '.png'
	for a in data:
		tv_archive = a['tv_archive']
		name ='[B][COLOR white]%s[/COLOR][/B]' % (a['name'])
		stream_id = a['stream_id']
		xtra1 =  a['stream_id']
		url1 = '%s/player_api.php?username=%s&password=%s&action=get_simple_data_table&stream_id=%s'%(dns,username,password,stream_id)
		if tv_archive == 1:
			if xbmcaddon.Addon().getSetting('hidexxx')=='true':
				addDir(name,url1,81,catchupicon,fanart,'[B][COLOR yellow]%s[/COLOR][/B]\n%s' % (xtra,'Catch Up Channels'),str(xtra1),dns,username,password)
			else:
				if not 'XXX' in name:
					if not 'Adult' in name:
						addDir(name,url1,81,catchupicon,fanart,'[B][COLOR yellow]%s[/COLOR][/B]\n%s' % (xtra,'Catch Up Channels'),str(xtra1),dns,username,password)


def catchup_programs(url,stream_id):#[81]
	days = 7
	now = str(datetime.datetime.now()).replace('-','').replace(':','').replace(' ','')
	catchup_start_date = datetime.datetime.now() - datetime.timedelta(days)
	date = str(catchup_start_date)
	date = str(date).replace('-','').replace(':','').replace(' ','')
	data = requests.get(url, headers=headers).json()
	fanart = hosts_fanart + xtra.lower() + '.png'
	for a in data['epg_listings']:
		channel_id = (a['channel_id']).upper().replace('.',' - ')
		title = base64.b64decode(a['title']).decode('utf-8')
		start = a['start']
		end = a['end']
		description = base64.b64decode(a['description']).decode('utf-8')
		description = '[B]%s[/B]\n[COLOR cyan]%s[/COLOR]\n%s' % (channel_id,title,description)
		format = '%Y-%m-%d %H:%M:%S'
		has_archive = a['has_archive']
		if has_archive == 1:
			try:
				modend = dtdeep.strptime(end, format)
				modstart = dtdeep.strptime(start, format)
			except:
				modend = datetime.datetime(*(time.strptime(end, format)[0:6]))
				modstart = datetime.datetime(*(time.strptime(start, format)[0:6]))
			StreamDuration = modend - modstart
			modend_ts = time.mktime(modend.timetuple())
			modstart_ts = time.mktime(modstart.timetuple())
			FinalDuration = int(modend_ts-modstart_ts) / 60
			strstart = start
			Realstart = str(strstart).replace('-','').replace(':','').replace(' ','')
			start2 = start[:-3]
			editstart = start2
			start2 = str(start2).replace(' ',' - ')
			start = str(editstart).replace(' ',':')
			Editstart = start[:13] + '-' + start[13:]
			final_start = (start[:13] + '-' + start[13:]).replace('-:','-')
			if Realstart > date:
				if Realstart < now:
					url1 = '%s/streaming/timeshift.php?username=%s&password=%s&stream=%s&start=%s&duration=%s'%(dns,username,password,stream_id,final_start,FinalDuration)
					name = "[COLOR yellow]%s[/COLOR] | %s"%(start2,title)
					if xbmcaddon.Addon().getSetting('hidexxx')=='true':
						addDir(name,url1,99,catchupicon,fanart,description,xtra,dns,username,password)
					else:
						if not 'XXX' in name:
							if not 'Adult' in name:
								addDir(name,url1,99,catchupicon,fanart,description,xtra,dns,username,password)


########################################

def stream_video(stream_url):#[99][999]
	text = '/live/'
	description = ''
	if text.lower() in stream_url.lower():
		stream_id = stream_url.split('/')[-1].split('.')[0]
		limit = 2
		try:
			description = str(get_short_epg(stream_id,limit))
		except:pass
	try:
		resp = requests.post(url=stream_url,allow_redirects=False)
		url = resp.headers["location"]
	except:
		url = stream_url
	liz = xbmcgui.ListItem()
	liz.setArt({'icon': iconimage, 'thumb': iconimage})
	liz.setInfo(type='Video', infoLabels={'Title': name, 'Plot': description})
	liz.setProperty('IsPlayable','true')
	liz.setPath(str(url))
	xbmcplugin.setResolvedUrl(int(sys.argv[1]), True, liz)


###################################SUB MENUS

def sub_menu_tools():
	fanart = hosts_fanart + xtra.lower() + '.png'
	if xbmcaddon.Addon().getSetting('meta')=='true':
		META = '[B][COLOR lime]ON[/COLOR][/B]'
	else:
		META = '[B][COLOR red]OFF[/COLOR][/B]'
	if xbmcaddon.Addon().getSetting('epg')=='true':
		EPG = '[B][COLOR lime]ON[/COLOR][/B]'
	else:
		EPG = '[B][COLOR red]OFF[/COLOR][/B]'
	if xbmcaddon.Addon().getSetting('hidexxx')=='true':
		XXX = '[B][COLOR lime]ON[/COLOR][/B]'
	else:
		XXX = '[B][COLOR red]OFF[/COLOR][/B]'
	if xbmcaddon.Addon().getSetting('showuserpass')=='true':
		USERPASS = '[B][COLOR lime]ON[/COLOR][/B]'
	else:
		USERPASS = '[B][COLOR red]OFF[/COLOR][/B]'
	url1 = '%s/player_api.php?username=%s&password=%s'%(dns,username,password)
	addDir('[B][COLOR white]Account Details[/COLOR][/B]',url1,1,accounticon,fanart,'[B][COLOR yellow]%s[/COLOR][/B]\n%s' % (xtra,'Account Details'),xtra,dns,username,password)
	addDir('[B][COLOR white]Movie Metadata is[/COLOR][/B] %s'%META,'META',10,dataicon,fanart,'%s\nMovie Metadata is %s' % (addon_name, META),xtra,dns,username,password)
	addDir('[B][COLOR white]XXX Channels are[/COLOR][/B] %s'%XXX,'XXX',10,xxxicon,fanart,'%s\nXXX Channels are %s' % (addon_name, XXX),xtra,dns,username,password)
	addDir('[B][COLOR white]Show Username/Password is[/COLOR][/B] %s'%USERPASS,'USERPASS',10,xxxicon,fanart,'%s\nShow Username/Password is %s' % (addon_name, USERPASS),xtra,dns,username,password)
	addDir('[B][COLOR white]Clear Cache[/COLOR][/B]','CC',10,cacheicon,fanart,'%s\n%s' % (addon_name, 'Clear Cache'),xtra,dns,username,password)
#	addDir('[B][COLOR white]Add-on Settings[/COLOR][/B]','AS',10,settingsicon,fanart,'Add-on Settings')
	addDir('[B][COLOR white]Edit Advanced Settings[/COLOR][/B]','ADS',10,advancedicon,fanart,'%s\n%s' % (addon_name, 'Edit Advanced Settings'),xtra,dns,username,password)
	addDir('[B][COLOR white]Run a Speed Test[/COLOR][/B]','ST',10,speedicon,fanart,'%s\n%s' % (addon_name, 'Run a Speed Test'),xtra,dns,username,password)
	addDir('[B][COLOR white]Log Out[/COLOR][/B]','LO',10,logouticon,fanart,'[B][COLOR yellow]%s[/COLOR][/B]\nLog Out:\n[B][COLOR orange]THIS WILL REMOVE USERNAME AND PASSWORD!![/COLOR][/B]'%(xtra),xtra,dns,username,password)
#		msg = '[B][COLOR yellow]%s[/COLOR][/B]\nSet up PVR Simple Client for Live TV and EPG:\n[B][COLOR orange]THIS WILL REMOVE ANY CURRENT PVR SIMPLE CLIENT SETUP!![/COLOR][/B]' % (xtra)
#		addDir('[B][COLOR white]Set up PVR Simple Client ([COLOR red]Live TV ONLY[/COLOR])[/COLOR][/B]','M3U8',10,speedicon,fanart,msg,xtra,dns,username,password)


###################################

def addonsettings(url,description):
	if url =="CC":
		tools.clear_cache()
	elif url =="AS":
		xbmc.executebuiltin('Addon.OpenSettings(%s)'%addon_id)
	elif url =="ADS":
		dialog = xbmcgui.Dialog().select('%s - %s' % (addon_name,'Edit Advanced Settings'), ['Enable Fire TV Stick AS','Enable Fire TV AS','Enable 1GB Ram or Lower AS','Enable 2GB Ram or Higher AS','Enable Nvidia Shield AS','Disable AS'])
		if dialog==0:
			advancedsettings('stick')
			xbmcgui.Dialog().ok(addon_name, 'Set Advanced Settings')
		elif dialog==1:
			advancedsettings('firetv')
			xbmcgui.Dialog().ok(addon_name, 'Set Advanced Settings')
		elif dialog==2:
			advancedsettings('lessthan')
			xbmcgui.Dialog().ok(addon_name, 'Set Advanced Settings')
		elif dialog==3:
			advancedsettings('morethan')
			xbmcgui.Dialog().ok(addon_name, 'Set Advanced Settings')
		elif dialog==4:
			advancedsettings('shield')
			xbmcgui.Dialog().ok(addon_name, 'Set Advanced Settings')
		elif dialog==5:
			advancedsettings('remove')
			xbmcgui.Dialog().ok(addon_name, 'Advanced Settings Removed')
	elif url =="ADS2":
		dialog = xbmcgui.Dialog().select('Select Your Device Or Closest To', ['Fire TV Stick ','Fire TV','1GB Ram or Lower','2GB Ram or Higher','Nvidia Shield'])
		if dialog==0:
			advancedsettings('stick')
			xbmcgui.Dialog().ok(addon_name, 'Set Advanced Settings')
		elif dialog==1:
			advancedsettings('firetv')
			xbmcgui.Dialog().ok(addon_name, 'Set Advanced Settings')
		elif dialog==2:
			advancedsettings('lessthan')
			xbmcgui.Dialog().ok(addon_name, 'Set Advanced Settings')
		elif dialog==3:
			advancedsettings('morethan')
			xbmcgui.Dialog().ok(addon_name, 'Set Advanced Settings')
		elif dialog==4:
			advancedsettings('shield')
			xbmcgui.Dialog().ok(addon_name, 'Set Advanced Settings')
	elif url =="tv":
		dialog = xbmcgui.Dialog().select('Select a TV Guide to Setup', ['iVue TV Guide','PVR TV Guide','Both'])
		if dialog==0:
			ivueint()
			xbmcgui.Dialog().ok(addon_name, 'iVue Integration Complete')
		elif dialog==1:
			pvrsetup()
			xbmcgui.Dialog().ok(addon_name, 'PVR Integration Complete')
		elif dialog==2:
			pvrsetup()
			ivueint()
			xbmcgui.Dialog().ok(addon_name, 'PVR & iVue Integration Complete')
	elif url =="ST":
		xbmc.executebuiltin('Runscript("special://home/addons/%s/resources/lib/modules/speedtest.py")' % addon_id)
	elif url =="META":
		if 'ON' in description:
			xbmcaddon.Addon().setSetting('meta','false')
			xbmc.executebuiltin('Container.Refresh')
		else:
			xbmcaddon.Addon().setSetting('meta','true')
			xbmc.executebuiltin('Container.Refresh')
	elif url =="EPG":
		if 'ON' in description:
			xbmcaddon.Addon().setSetting('epg','false')
			xbmc.executebuiltin('Container.Refresh')
		else:
			xbmcaddon.Addon().setSetting('epg','true')
			xbmc.executebuiltin('Container.Refresh')
	elif url =="XXX":
		if 'ON' in description:
			xbmcaddon.Addon().setSetting('hidexxx','false')
			xbmc.executebuiltin('Container.Refresh')
		else:
			xbmcaddon.Addon().setSetting('hidexxx','true')
			xbmc.executebuiltin('Container.Refresh')
	elif url =="USERPASS":
		if 'ON' in description:
			xbmcaddon.Addon().setSetting('showuserpass','false')
			xbmc.executebuiltin('ReplaceWindow(Videos,addons://sources/video/)')
			xbmc.executebuiltin('Container.Update(path,replace)')
			xbmc.executebuiltin('RunAddon(%s)' % (addon_id))
		else:
			xbmcaddon.Addon().setSetting('showuserpass','true')
			xbmc.executebuiltin('ReplaceWindow(Videos,addons://sources/video/)')
			xbmc.executebuiltin('Container.Update(path,replace)')
			xbmc.executebuiltin('RunAddon(%s)' % (addon_id))
	elif url =="LO":
		msg = "[B][COLOR red]THIS WILL REMOVE ANY EXISTING[/COLOR][COLOR yellow] %s [/COLOR][COLOR red]USERNAME AND PASSWORD[/COLOR][/B]" % (xtra)
		dialog = xbmcgui.Dialog()
		ret = dialog.yesno('Attention', msg, 'Cancel', 'Continue')
		if ret == True:
			pass
		else:
			return
		users_delete()
		xbmc.executebuiltin('ReplaceWindow(Videos,addons://sources/video/)')
		xbmc.executebuiltin('Container.Update(path,replace)')
		xbmc.executebuiltin('RunAddon(%s)' % (addon_id))
	elif url =="UPDATE":
		if 'ON' in description:
			xbmcaddon.Addon().setSetting('update','false')
			xbmc.executebuiltin('Container.Refresh')
		else:
			xbmcaddon.Addon().setSetting('update','true')
			xbmc.executebuiltin('Container.Refresh')
	elif url == "M3U8":
		msg = "[B][COLOR red]THIS WILL REMOVE ANY EXISTING PVR SIMPLE CLIENT SETUP[/COLOR][/B]"
		dialog = xbmcgui.Dialog()
		ret = dialog.yesno('Attention', msg, 'Cancel', 'Continue')
		if ret == True:
			pass
		else:
			return
		try:
			addon = xbmcaddon.Addon('pvr.iptvsimple')
		except:
			msg = "[B][COLOR red]PVR Simple Client Not Found[/COLOR][/B]\nPlease install add-on PVR Simple Client"
			dialog = xbmcgui.Dialog()
			ret = dialog.yesno('Attention', msg, 'Install', 'Exit')
			if ret == True:
				return
			else:
				installAddon("pvr.iptvsimple")
		create_live_m3u(xtra)
		pvr_simple_client_setup(xtra)
		IPTVtoggle = '{"jsonrpc":"2.0","method":"Addons.SetAddonEnabled","params":{"addonid":"pvr.iptvsimple","enabled":"toggle"},"id":1}'
		msg = "[B][COLOR orange]PVR Simple Client Set up Complete[/COLOR][/B]\nPlease wait it can take a few minutes for Initiation"
		xbmcgui.Dialog().ok(addon_name, msg)
		IPTVon = '{"jsonrpc":"2.0","method":"Addons.SetAddonEnabled","params":{"addonid":"pvr.iptvsimple","enabled":true},"id":1}'
		xbmc.executeJSONRPC(IPTVon)
		xbmc.executebuiltin('ActivateWindow(TVGuide)')
		xbmc.executebuiltin('Container.Refresh')


def advancedsettings(device):
	if device == 'stick':
		file = open(os.path.join(advanced_settings, 'stick.xml'))
	elif device == 'firetv':
		file = open(os.path.join(advanced_settings, 'firetv.xml'))
	elif device == 'lessthan':
		file = open(os.path.join(advanced_settings, 'lessthan1GB.xml'))
	elif device == 'morethan':
		file = open(os.path.join(advanced_settings, 'morethan1GB.xml'))
	elif device == 'shield':
		file = open(os.path.join(advanced_settings, 'shield.xml'))
	elif device == 'remove':
		os.remove(advanced_settings_target)
	try:
		read = file.read()
		f = open(advanced_settings_target, mode='w+')
		f.write(read)
		f.close()
	except:
		pass


########################################PVR SETUP

def installAddon(IDdoADDON):
	pathTOaddon = os.path.join(xbmcvfs.translatePath('special://home/addons'), IDdoADDON)
	if not os.path.exists(pathTOaddon)==True:
		xbmc.executebuiltin('InstallAddon(%s)' % (IDdoADDON))
		xbmc.executebuiltin('SendClick(11)'), time.sleep(2), xbmcgui.Dialog().ok("Add-on Install", "The addon was not present. Please wait for installation to finish.")
	else:
		pass
	if os.path.exists(pathTOaddon)==True:
		return
	else:
		xbmcgui.Dialog().ok("Add-on Error", "Could not install or open add-on. Please try again...")


def create_live_m3u(xtra):
	url = '%s/player_api.php?username=%s&password=%s&action=get_live_categories'%(dns,username,password)
	data = requests.get(url, headers=headers).json()
	categories = []
	for a in data:
		category_id = a['category_id']
		category_name = a['category_name']
		categories.append(category_id)
		categories.append(category_name)
	url = '%s/player_api.php?username=%s&password=%s&action=get_live_streams'%(dns,username,password)
	data = requests.get(url, headers=headers).json()
	m3u_file_path = xbmcvfs.translatePath(os.path.join('special://home/userdata/playlists/video', addon_id +'_live.m3u'))
	f = xbmcvfs.File(m3u_file_path,'w')
	file_data = '#EXTM3U\n'
	for a in data:
		num = a['num']
		name = a['name']
		stream_type = a['stream_type']
		stream_id = a['stream_id']
		stream_icon = a['stream_icon']
		epg_channel_id = a['epg_channel_id']
		category_id = a['category_id']
		try:
			category = categories[(categories.index(a['category_id'])+1)]
		except:
			category = category_id = a['category_id']
		stream_url = '%s/%s/%s/%s/%s.ts'%(dns,stream_type,username,password,stream_id)
		file_data += '#EXTINF:-1 tvg-id="%s" tvg-name="%s" tvg-logo="%s" group-title="%s", %s\n%s\n' % (num, name, stream_icon, category, name, stream_url)
	f.write(file_data)
	f.close() 


def pvr_simple_client_setup(xtra):
	jsonPVRon	= '{"jsonrpc":"2.0", "method":"Settings.SetSettingValue", "params":{"setting":"pvrmanager.enabled", "value":true},"id":1}'
	IPTVoff		= '{"jsonrpc":"2.0","method":"Addons.SetAddonEnabled","params":{"addonid":"pvr.iptvsimple","disable":true},"id":1}'
	IPTVon		= '{"jsonrpc":"2.0","method":"Addons.SetAddonEnabled","params":{"addonid":"pvr.iptvsimple","enabled":true},"id":1}'
	IPTVtoggle	= '{"jsonrpc":"2.0","method":"Addons.SetAddonEnabled","params":{"addonid":"pvr.iptvsimple","enabled":"toggle"},"id":1}'
	if xtra.lower() == 'maximum':
		user_agent = ' |User-Agent="YanTanTethera"'
	else:
		user_agent = ''
	m3u_file_path = xbmcvfs.translatePath(os.path.join('special://home/userdata/playlists/video', addon_id +'_live.m3u'))
	epg_url = '%s/xmltv.php?username=%s&password=%s%s' % (dns,username,password,user_agent)
	addon = xbmcaddon.Addon('pvr.iptvsimple')
	addon.setSetting('m3uPathType', '0')#0 = LocalPath
	addon.setSetting('m3uPath', m3u_file_path)#Local
	addon.setSetting('m3uRefreshMode', '2')
	addon.setSetting('epgPathType', '1')#1 = URL
	addon.setSetting('epgUrl', epg_url)#
	addon.setSetting('defaultUserAgent', 'YanTanTethera')#
	xbmc.executebuiltin("Container.Refresh")
	xbmc.executeJSONRPC(IPTVtoggle)
	return

###################################


def account_info(key,dns,username,password):
	url = '%s/player_api.php?username=%s&password=%s'%(dns,username,password)
	try:
		data = requests.get(url, headers=headers).json()
		active = data['user_info']['active_cons']
		status = data['user_info']['status']
		if key == 'expiry':
			expiry = data['user_info']['exp_date']
			expiry = datetime.datetime.fromtimestamp(int(expiry)).strftime('%d/%m/%Y - %H:%M')
			expreg = re.compile('^(.*?)/(.*?)/(.*?)$',re.DOTALL).findall(expiry)
			for day,month,year in expreg:
				month = tools.MonthNumToName(month)
				year = re.sub(' -.*?$','',year)
				key = month+' '+day+' - '+year
#	except:pass
	except:
		key = '[COLOR red]EXPIRED[/COLOR]'
	return key


def accountinfo(url):#[1]
	fanart = hosts_fanart + xtra.lower() + '.png'
	description = '[B][COLOR cyan]%s[/COLOR][/B]\n%s' % (xtra,'Live Channels')
	try:
		data = requests.get(url, headers=headers).json()
		for a in data['user_info']:
			username = data['user_info']['username']
			password = data['user_info']['password']
			status = data['user_info']['status']
			connects = data['user_info']['max_connections']
			active = data['user_info']['active_cons']
			expiry = data['user_info']['exp_date']
			expiry = datetime.datetime.fromtimestamp(int(expiry)).strftime('%d/%m/%Y - %H:%M')
			expreg = re.compile('^(.*?)/(.*?)/(.*?)$',re.DOTALL).findall(expiry)
		for day,month,year in expreg:
			month = tools.MonthNumToName(month)
			year = re.sub(' -.*?$','',year)
			expiry = month+' '+day+' - '+year
		addDir('[B][COLOR red]Account Status :[/COLOR][/B] %s'%status,'',11,statusicon,fanart,'[B][COLOR yellow]%s[/COLOR][/B]\n%s' % (xtra,'Account Status'),xtra,dns,username,password)
		addDir('[B][COLOR red]Expiry Date:[/COLOR][/B] '+expiry,'',11,dateicon,fanart,'[B][COLOR yellow]%s[/COLOR][/B]\n%s' % (xtra,'Expiry Date'),xtra,dns,username,password)
		addDir('[B][COLOR red]Username :[/COLOR][/B] '+username,'',11,usericon,fanart,'[B][COLOR yellow]%s[/COLOR][/B]\n%s' % (xtra,'Username'),xtra,dns,username,password)
		addDir('[B][COLOR red]Password :[/COLOR][/B] '+password,'',11,passicon,fanart,'[B][COLOR yellow]%s[/COLOR][/B]\n%s' % (xtra,'Password'),xtra,dns,username,password)
		addDir('[B][COLOR red]Allowed Connections:[/COLOR][/B] '+connects,'',11,allowedicon,fanart,'[B][COLOR yellow]%s[/COLOR][/B]\n%s' % (xtra,'Allowed Connections'),xtra,dns,username,password)
		addDir('[B][COLOR red]Current Connections:[/COLOR][/B] '+ active,'',11,currenticon,fanart,'[B][COLOR yellow]%s[/COLOR][/B]\n%s' % (xtra,'Current Connections'),xtra,dns,username,password)
	except:pass


########################################

def addDir(name,url,mode,iconimage,fanart,description,xtra,dns,username,password):
	u=sys.argv[0]+"?url="+urllib.parse.quote(url)+"&mode="+str(mode)+"&name="+urllib.parse.quote(name)+"&iconimage="+urllib.parse.quote(iconimage)+"&description="+urllib.parse.quote(description)+"&xtra="+urllib.parse.quote(xtra)+"&username="+urllib.parse.quote(username)+"&password="+urllib.parse.quote(password)+"&dns="+urllib.parse.quote(dns)
	ok=True
	liz = xbmcgui.ListItem(name)
	liz.setIsFolder(True)
	liz.setArt({'icon': iconimage, 'thumb': iconimage})
	liz.setProperty('fanart_image', fanart)
	if mode==99:
		liz.setInfo( type="Video", infoLabels={"Title": name,"Plot":description})
		liz.setProperty("IsPlayable","true")
		ok=xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]),url=u,listitem=liz,isFolder=False)
	elif mode==999:
		liz.setInfo( type="Video", infoLabels={"Title": name})
		liz.setProperty("IsPlayable","true")
		ok=xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]),url=u,listitem=liz,isFolder=False)
	elif mode==10 or mode==11:
		liz.setInfo( type="Video", infoLabels={"Title": name,"Plot":description})
		ok=xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]),url=u,listitem=liz,isFolder=False)
	else:
		genre = ''
		liz.setInfo( 'Video', {"Title": name,"Plot":description,'genre':genre})
		ok=xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]),url=u,listitem=liz,isFolder=True)
	return ok
	xbmcplugin.endOfDirectory


def addDirMeta(name,url,mode,iconimage,fanart,description,year,director,cast,rating,runtime,genre,xtra,dns,username,password):
	u=sys.argv[0]+"?url="+urllib.parse.quote(url)+"&mode="+str(mode)+"&name="+urllib.parse.quote(name)+"&iconimage="+urllib.parse.quote(iconimage)+"&description="+urllib.parse.quote(description)+"&xtra="+urllib.parse.quote(xtra)+"&username="+urllib.parse.quote(username)+"&password="+urllib.parse.quote(password)+"&dns="+urllib.parse.quote(dns)
	ok=True
	liz=xbmcgui.ListItem(name)
	liz.setArt({'icon': iconimage, 'thumb': iconimage, 'poster': iconimage, 'banner': fanart})
	liz.setInfo( 'video', {'title': name,'plot':description,'rating':rating,'year':year,'duration':runtime,'director':director,'cast':cast,'genre':genre})
	liz.setProperty('fanart_image', fanart)
	if mode==54 or mode==44 or mode ==55:
		liz.setProperty("IsPlayable","false")
		ok=xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]),url=u,listitem=liz,isFolder=True)
	else:
		liz.setProperty("IsPlayable","true")
		ok=xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]),url=u,listitem=liz,isFolder=False)
	return ok
	xbmcplugin.endOfDirectory


def get_params():
	param=[]
	paramstring=sys.argv[2]
	if len(paramstring)>=2:
		params=sys.argv[2]
		cleanedparams=params.replace('?','')
		if (params[len(params)-1]=='/'):
			params=params[0:len(params)-2]
		pairsofparams=cleanedparams.split('&')
		param={}
		for i in range(len(pairsofparams)):
			splitparams={}
			splitparams=pairsofparams[i].split('=')
			if (len(splitparams))==2:
				param[splitparams[0]]=splitparams[1]
	return param


########################################

params=get_params()
url=None
name=None
mode=None
iconimage=None
description=None
xtra=None
dns=None
username=None
password=None

try:
	url=urllib.parse.unquote(params["url"])
except:
	pass
try:
	name=urllib.parse.unquote(params["name"])
except:
	pass
try:
	iconimage=urllib.parse.unquote(params["iconimage"])
except:
	pass
try:
	mode=int(params["mode"])
except:
	pass
try:
	description=urllib.parse.unquote(params["description"])
except:
	pass
try:
	xtra=urllib.parse.unquote(params["xtra"])
except:
	pass
try:
	dns=urllib.parse.unquote(params["dns"])
except:
	pass
try:
	username=urllib.parse.unquote(params["username"])
except:
	pass
try:
	password=urllib.parse.unquote(params["password"])
except:
	pass

########################################

if mode==None or url==None or len(url)<1:
	xbmcplugin.setContent(int(sys.argv[1]), 'videos')
	hosts()

elif mode==1:
	xbmcplugin.setContent(int(sys.argv[1]), 'videos')
	accountinfo(url)

#############LIVE
elif mode==2:
	xbmcplugin.setContent(int(sys.argv[1]), 'videos')
	sub_menu_live()

elif mode==21:
	xbmcplugin.setContent(int(sys.argv[1]), 'videos')
	get_live_streams_all()

elif mode==22:
	xbmcplugin.setContent(int(sys.argv[1]), 'videos')
	get_live_categories()

elif mode==23:
	xbmcplugin.setContent(int(sys.argv[1]), 'videos')
	get_live_streams_category()

elif mode==29:
	xbmcplugin.setContent(int(sys.argv[1]), 'videos')
	search_live()

#############MOVIES
elif mode==4:
	xbmcplugin.setContent(int(sys.argv[1]), 'movies')
	sub_menu_vod()

elif mode==41:
	xbmcplugin.setContent(int(sys.argv[1]), 'movies')
	get_vod_streams_all()

elif mode==42:
	xbmcplugin.setContent(int(sys.argv[1]), 'videos')
	get_vod_categories()

elif mode==43:
	xbmcplugin.setContent(int(sys.argv[1]), 'movies')
	get_vod_streams_by_catagory(url)

elif mode==44:
	xbmcplugin.setContent(int(sys.argv[1]), 'movies')
	get_vod_info(url)

elif mode==49:
	xbmcplugin.setContent(int(sys.argv[1]), 'movies')
	search_vod()

#############SERIES
elif mode==5:
	xbmcplugin.setContent(int(sys.argv[1]), 'videos')
	sub_menu_series()

elif mode==51:
	xbmcplugin.setContent(int(sys.argv[1]), 'tvshows')
	get_series_streams_all()

elif mode==52:
	xbmcplugin.setContent(int(sys.argv[1]), 'videos')
	get_series_categories()

elif mode==53:
	xbmcplugin.setContent(int(sys.argv[1]), 'tvshows')
	get_series_by_category(url)

elif mode==54:
	xbmcplugin.setContent(int(sys.argv[1]), 'tvshows')
	get_series_info(url)

elif mode==55:
	xbmcplugin.setContent(int(sys.argv[1]), 'episodes')
	get_series_episodes(url,xtra)

elif mode==59:
	xbmcplugin.setContent(int(sys.argv[1]), 'tvshows')
	search_series()

#############
elif mode==6:
	xbmcplugin.setContent(int(sys.argv[1]), 'videos')
	sub_menu_search()

#############
elif mode==7:
	xbmcplugin.setContent(int(sys.argv[1]), 'videos')
	sub_menu_tools()

#############CATCHUP
elif mode==8:
	xbmcplugin.setContent(int(sys.argv[1]), 'videos')
	catchup_channels()

elif mode==81:
	xbmcplugin.setContent(int(sys.argv[1]), 'videos')
	catchup_programs(url,xtra)

##############
elif mode==99 or mode==999:
	stream_video(url)

##############
elif mode==100:
	xbmc.executebuiltin('PlayMedia(plugin://plugin.video.youtube/play/?video_id=%s)'% url)

elif mode ==101:
	xbmcplugin.setContent(int(sys.argv[1]), 'videos')
	check(xtra)

elif mode==10:
	addonsettings(url,description)


xbmcplugin.endOfDirectory(int(sys.argv[1]))
